require('dotenv').config();

module.exports = ({config}) => {
    return {
        ...config,
        name: process.env.APP_NAME,
        slug: process.env.APP_SLUG,
        icon: process.env.ICON,
        scheme: [process.env.SCHEME, process.env.FACEBOOK_CLIENT_SCHEME],
        splash: {
            ...config.splash,
            image: process.env.SPLASH,
            backgroundColor: process.env.SPLASH_BACKGROUND_COLOR
        },
        ios: {
            ...config.ios,
            bundleIdentifier: process.env.IDENTIFIER,
        },
        android: {
            ...config.android,
            package: process.env.IDENTIFIER,
            adaptiveIcon: {
                ...config.android.adaptiveIcon,
                foregroundImage: process.env.ANDROID_FOREGROUND_IMAGE,
                backgroundColor: process.env.ANDROID_ADAPTIVE_BACKGROUND_COLOR
            }
        },
        extra: {
            eas: {
                projectId: "fd9147eb-0b76-437a-a9b4-993b4995bd19"
            }
        },
        plugins: [
            [
                "expo-build-properties",
                {
                "android": {
                    useLegacyPackaging: true,
                    enableProguardInReleaseBuilds: true,
                    enableShrinkResourcesInReleaseBuilds: true
                },
                }
           ],

          "expo-secure-store",
        ]
    }
}